package com.wissamfawaz;

public class DNode<T> implements Position<T> {
    private T element;
    private DNode<T> previous, next;

    public DNode(DNode<T> p, T e, DNode<T> n) {
        element = e;
        previous = p;
        next = n;
    }

    @Override
    public T getElement() {
        return element;
    }

    public void setElement(T element) {
        this.element = element;
    }

    public DNode<T> getPrevious() {
        return previous;
    }

    public void setPrevious(DNode<T> previous) {
        this.previous = previous;
    }

    public DNode<T> getNext() {
        return next;
    }

    public void setNext(DNode<T> next) {
        this.next = next;
    }

    @Override
    public String toString() {
        return element.toString();
    }

    public void removeBindings() {
        if(previous != null) {
            previous.next = next;
        }

        if(next != null) {
            next.previous = previous;
        }

        previous = null;
        next = null;
    }
    
}
